package ru.yandex.mail.so.factors.predicates;

import java.io.IOException;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public class NotPredicate implements SoPredicate {
    private final SoPredicate predicate;

    public NotPredicate(final SoPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public void close() throws IOException {
        predicate.close();
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return predicate.inputs();
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        predicate.registerInternals(registry);
    }

    @Override
    public boolean test(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs)
    {
        return !predicate.test(context, inputs);
    }

    @Override
    public String toString() {
        return "not " + predicate.toString();
    }
}

