package ru.yandex.mail.so.factors.predicates;

import java.io.IOException;
import java.util.List;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

// SoPredicate is (relatively) fast function which accepts list of input
// factors and returns boolean
public interface SoPredicate extends GenericAutoCloseable<IOException> {
    boolean test(
        SoFactorsExtractorContext context,
        SoFunctionInputs inputs);

    List<SoFactorType<?>> inputs();

    void registerInternals(SoFactorsExtractorsRegistry typesRegistry)
        throws ConfigException;
}

