package ru.yandex.mail.so.factors.predicates;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum StringsEqualPredicate implements SoPredicate {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            StringSoFactorType.STRING,
            StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }

    @Override
    public boolean test(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs)
    {
        String lhs = inputs.get(0, StringSoFactorType.STRING);
        String rhs = inputs.get(1, StringSoFactorType.STRING);
        return Objects.equals(lhs, rhs);
    }
}

