package ru.yandex.mail.so.factors.senders;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class SenderResponse implements Serializable {
    private static final long serialVersionUID = 0L;

    private final long uid;
    private final Long suid;
    private final String email;
    private final String domain;
    private final String senderHost;
    private final List<String> inReplyTo;
    private final List<String> references;

    private final long sentCount;
    private final long receivedCount;
    private final long receivedReadCount;
    private final long lastContacted;

    private final long domainSentCount;
    private final long domainReceivedCount;
    private final long domainReceivedReadCount;

    private final String pfilterLastType;
    private final long pfilterSpams;
    private final long pfilterHams;

    private final String tabPfLastTab;

    private final JsonObject userMlFeatures;
    private final JsonObject userMlEmbeddings;

    private final boolean inReplyToMatches;
    private final boolean referencesMatches;

    public SenderResponse(final JsonMap map)
        throws JsonException
    {
        JsonMap request = map.get("request").asMap();
        uid = request.getLong("uid");
        suid = request.getLong("suid", null);
        email = request.getString("email", null);
        domain = request.getString("domain", null);
        senderHost = request.getString("sender-host", null);
        inReplyTo = convertStringList(request.getListOrNull("in-reply-to"));
        references = convertStringList(request.getListOrNull("references"));

        JsonMap response = map.get("response").asMap();
        sentCount = response.getLong("sent_count", 0L);
        receivedCount = response.getLong("received_count", 0L);
        receivedReadCount = response.getLong("received_read_count", 0L);
        lastContacted = response.getLong("last_contacted", 0L);

        domainSentCount = response.getLong("domain_send_count", 0L);
        domainReceivedCount = response.getLong("domain_received_count", 0L);
        domainReceivedReadCount =
            response.getLong("domain_received_read_count", 0L);

        pfilterLastType = response.getString("pfilters_last_type", null);
        pfilterSpams = response.getLong("pfilters_spams", 0L);
        pfilterHams = response.getLong("pfilters_hams", 0L);

        tabPfLastTab = response.getString("tabpf_last_tab", null);

        userMlFeatures = parseJson(response.get("user_ml_features"));
        userMlEmbeddings = parseJson(response.get("user_ml_embeddings"));

        inReplyToMatches = response.getBoolean("in_reply_to_matches", false);
        referencesMatches = response.getBoolean("references_matches", false);
    }

    private static JsonObject parseJson(final JsonObject json)
        throws JsonException
    {
        if (json == JsonNull.INSTANCE) {
            return JsonNull.INSTANCE;
        } else {
            return TypesafeValueContentHandler.parse(json.asString());
        }
    }

    private static List<String> convertStringList(final JsonList list)
        throws JsonException
    {
        if (list == null) {
            return Collections.emptyList();
        } else {
            int size = list.size();
            if (size == 0) {
                return Collections.emptyList();
            } else {
                List<String> result = new ArrayList<>(size);
                for (int i = 0; i < size; ++i) {
                    result.add(list.get(i).asString());
                }
                return result;
            }
        }
    }

    public long uid() {
        return uid;
    }

    public Long suid() {
        return suid;
    }

    public String email() {
        return email;
    }

    public String domain() {
        return domain;
    }

    public String senderHost() {
        return senderHost;
    }

    public List<String> inReplyTo() {
        return inReplyTo;
    }

    public List<String> references() {
        return references;
    }

    public long sentCount() {
        return sentCount;
    }

    public long receivedCount() {
        return receivedCount;
    }

    public long receivedReadCount() {
        return receivedReadCount;
    }

    public long lastContacted() {
        return lastContacted;
    }

    public long domainSentCount() {
        return domainSentCount;
    }

    public long domainReceivedCount() {
        return domainReceivedCount;
    }

    public long domainReceivedReadCount() {
        return domainReceivedReadCount;
    }

    public String pfilterLastType() {
        return pfilterLastType;
    }

    public long pfilterSpams() {
        return pfilterSpams;
    }

    public long pfilterHams() {
        return pfilterHams;
    }

    public String tabPfLastTab() {
        return tabPfLastTab;
    }

    public JsonObject userMlFeatures() {
        return userMlFeatures;
    }

    public JsonObject userMlEmbeddings() {
        return userMlEmbeddings;
    }

    public boolean inReplyToMatches() {
        return inReplyToMatches;
    }

    public boolean referencesMatches() {
        return referencesMatches;
    }
}

