package ru.yandex.mail.so.factors.senders;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.JsonListSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.mail.senders.SendersContext;

public enum SendersInfoExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(JsonListSoFactorType.JSON_LIST);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(SendersInfoSoFactorType.SENDERS_INFO);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonList headers = inputs.get(0, JsonListSoFactorType.JSON_LIST);
        if (headers == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        try{
            int size = headers.size();
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, JsonObject> header =
                    headers.get(i).asMap().entrySet().iterator().next();
                sb.append(header.getKey());
                sb.append(':');
                sb.append(' ');
                sb.append(header.getValue().asString());
                sb.append('\n');
            }
            callback.completed(
                Collections.singletonList(
                    SendersInfoSoFactorType.SENDERS_INFO.createFactor(
                        new SendersContext(new String(sb)).extractSenders())));
        } catch (Exception e) {
            callback.failed(e);
            return;
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonListSoFactorType.JSON_LIST);
        registry.typesRegistry().registerSoFactorType(
            SendersInfoSoFactorType.SENDERS_INFO);
    }
}

