package ru.yandex.mail.so.factors.senders;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.mail.senders.SenderInfo;
import ru.yandex.parser.mail.senders.SendersInfo;

public enum SendersInfoSoFactorType implements SoFactorType<SendersInfo> {
    SENDERS_INFO;

    @Override
    public SendersInfo cast(final Object value) {
        if (value instanceof SendersInfo) {
            return (SendersInfo) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        switch (fieldName) {
            case "__size__":
                return new SizeAccessor(this);
            case "__json_map__":
                return new JsonAccessor(
                    this,
                    JsonMapSoFactorType.JSON_MAP,
                    ".__json_map__");
            case "__json_object__":
                return new JsonAccessor(
                    this,
                    JsonObjectSoFactorType.JSON_OBJECT,
                    ".__json_object__");
            default:
                return null;
        }
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof SendersInfo) {
                return (long) ((SendersInfo) value).size();
            } else {
                return null;
            }
        }
    }

    public static class JsonAccessor extends SoFactorFieldAccessorBase {
        public JsonAccessor(
            final SoFactorType<?> variableType,
            final SoFactorType<?> fieldType,
            final String stringValue)
        {
            super(variableType, fieldType, stringValue);
        }

        @Override
        public JsonMap extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof SendersInfo) {
                SendersInfo input = (SendersInfo) value;
                int size = input.size();
                JsonMap map =
                    new JsonMap(BasicContainerFactory.INSTANCE, size << 1);
                for (int i = 0; i < size; ++i) {
                    SenderInfo info = input.get(i);
                    map.put(
                        info.type().toString(),
                        new JsonString(info.email()));
                }
                return map;
            }
            return null;
        }
    }
}

