package ru.yandex.mail.so.factors.senders;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SendersResponseStatsReporter implements SendersResponseListener {
    private final Consumer<String> resolutionConsumer;
    private final Logger logger;

    public SendersResponseStatsReporter(
        final Consumer<String> resolutionConsumer,
        final Logger logger)
    {
        this.resolutionConsumer = resolutionConsumer;
        this.logger = logger;
    }

    @Override
    public void personalFilterResult(final long uid, final String resolution) {
        if (resolution != null && logger.isLoggable(Level.FINE)) {
            logger.fine(
                "For uid " + uid + " pfilters resolution is: " + resolution);
        }
        resolutionConsumer.accept(Objects.toString(resolution));
    }
}

