package ru.yandex.mail.so.factors.sherlock;

import java.util.List;

public class EmailAttributes {
    String from;
    String subject;
    String qid;
    List<Long> uids;

    public EmailAttributes(
        String from,
        String subject,
        String qid,
        List<Long> uids)
    {
        this.from = from;
        this.subject = subject;
        this.qid = qid;
        this.uids = uids;
    }

    public String from() {
        return from;
    }

    public String subject() {
        return subject;
    }

    public String qid() {
        return qid;
    }

    public List<Long> uids() {
        return uids;
    }

    // Must be consistent with mail/template_master/lib/template_master/
    //  content_processor/email_attributes.h ::GetAttributesEternal
    public boolean isManuallyCreated() {
        return "MANUALLY CREATED".equals(qid);
    }
}
