package ru.yandex.mail.so.factors.sherlock;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

import javax.annotation.concurrent.ThreadSafe;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.compress.Deflater;
import ru.yandex.compress.GzipOutputStream;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HeaderUtils;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityGenerator;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

@ThreadSafe
public class TemplateMasterClient
    extends AbstractAsyncClient<TemplateMasterClient>
{
    private static final ContentType CONTENT_TYPE =
        ContentType.TEXT_HTML.withCharset(StandardCharsets.UTF_8);
    private static final Header GZIP_CONTENT_ENCODING =
        HeaderUtils.createHeader(HttpHeaders.CONTENT_ENCODING, "gzip");

    private final HttpHost host;

    public TemplateMasterClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
        host = config.host();
    }

    private TemplateMasterClient(
        final CloseableHttpAsyncClient client,
        final TemplateMasterClient sample)
    {
        super(client, sample);
        host = sample.host;
    }

    @Override
    protected TemplateMasterClient adjust(CloseableHttpAsyncClient client) {
        return new TemplateMasterClient(client, this);
    }

    public void detemple(
        final String html,
        final String attributes,
        final String domain,
        final Supplier<? extends HttpClientContext> contextGenerator,
        final FutureCallback<? super TemplateMasterResponse> callback)
        throws BadRequestException
    {
        QueryConstructor qc = new QueryConstructor("/route?", false);
        qc.append("domain", domain);
        qc.append("attributes", attributes);
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream(html.length() >> 2);
        try (GzipOutputStream gzip =
            new GzipOutputStream(out, 4096, false, Deflater.BEST_SPEED))
        {
            gzip.write(StringUtils.getUtf8Bytes(html));
        } catch (IOException e) {
            callback.failed(e);
        }
        execute(
            host,
            new BasicAsyncRequestProducerGenerator(
                qc.toString(),
                new NByteArrayEntityGenerator(
                    out,
                    CONTENT_TYPE,
                    GZIP_CONTENT_ENCODING)),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            contextGenerator,
            new Callback(callback));
    }


    private static class Callback
        extends AbstractFilterFutureCallback<
        JsonObject,
        TemplateMasterResponse>
    {

        Callback(FutureCallback<? super TemplateMasterResponse> callback) {
            super(callback);
        }

        @Override
        public void completed(JsonObject result) {
            try {
                callback.completed(new TemplateMasterResponse(result));
            } catch (JsonException e) {
                e.addSuppressed(
                    new JsonException(
                        "Failed to parse response: "
                            + JsonType.HUMAN_READABLE.toString(result)));
                failed(e);
            }
        }
    }

}
