package ru.yandex.mail.so.factors.sherlock;

import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.extractors.IniConfigSoFactorsExtractorFactory;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SmtpEnvelopeSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.TikaiteDocSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum TemplateMasterExtractorFactory
    implements IniConfigSoFactorsExtractorFactory
{
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoFactorsExtractor createIniConfigExtractor(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        return new TemplateMasterExtractor(name, context, config);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        // Input: body, subject
        registry.typesRegistry().registerSoFactorType(
            TikaiteDocSoFactorType.TIKAITE_DOC);
        // Input: qid and uids
        registry.typesRegistry().registerSoFactorType(
            SmtpEnvelopeSoFactorType.SMTP_ENVELOPE);
        // Output: { delta: <LIST OF TOKENS>,
        //           stable_sign: <long>, donor_and_contains_urls: <bool>}
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
    }
}
