package ru.yandex.mail.so.factors.sherlock;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.so.factors.types.StringList;

public class TemplateMasterResponse {
    private DetempleStatus status;
    private StringList delta;
    private Long stableSign;
    private JsonList attributes;

    public TemplateMasterResponse(final JsonObject response)
        throws JsonException
    {
        status = DetempleStatus.valueOf(response.asMap().getString("status"));
        stableSign = response.asMap().getLong("stable_sign", null);

        JsonList rawDelta = response.asMap().getListOrNull("delta");
        if (rawDelta != null) {
            delta = new StringList(rawDelta.size());
            for (JsonObject deltaChunk : rawDelta) {
                if (deltaChunk instanceof JsonList) {
                    for (JsonObject token : deltaChunk.asList()) {
                        delta.add(token.asString());
                    }
                } else {
                    delta.add(deltaChunk.asString());
                }
            }
        }

        attributes = response.asMap().getListOrNull("attributes");
    }

    public StringList delta() {
        return delta;
    }

    public Long stableSign() {
        return stableSign;
    }

    public DetempleStatus status() {
        return status;
    }

    // Not used, so no further parsing.
    public JsonList attributes() {
        return attributes;
    }

    public boolean hasTemplate() {
        return status != DetempleStatus.Error
            && status != DetempleStatus.NotFound;
    }

    public enum DetempleStatus {
        FoundInDb,
        NotFound,
        Error // For now not used
    }
}
