package ru.yandex.mail.so.factors.shinglers.activity;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.so.api.v1.EmailInfo;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.JsonObjectSoFactorCallback;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SmtpEnvelopeSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.envelope.SmtpEnvelopeHolder;

public class ActivityExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(SmtpEnvelopeSoFactorType.SMTP_ENVELOPE);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(JsonObjectSoFactorType.JSON_OBJECT);
    private static final List<SoFactor<?>> EMPTY_RESULT =
        Collections.singletonList(
            JsonObjectSoFactorType.JSON_OBJECT.createFactor(JsonList.EMPTY));

    private final AsyncClient client;
    private final HttpHost host;

    public ActivityExtractor(
        final String name,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        ImmutableHttpHostConfig hostConfig =
            new HttpHostConfigBuilder(config).build();
        client = context.asyncClientRegistrar().client(name, hostConfig);
        host = hostConfig.host();
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        SmtpEnvelopeHolder envelope =
            inputs.get(0, SmtpEnvelopeSoFactorType.SMTP_ENVELOPE);
        if (envelope == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        List<EmailInfo> recipients = envelope.recipients();
        int size = recipients.size();
        boolean empty = true;
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.NORMAL.create(sbw)) {
            writer.startArray();
            writer.startObject();
            writer.key("type");
            writer.value("Get");
            writer.key("scheme");
            writer.startArray();
            writer.value("activity");
            writer.value("compls");
            writer.endArray();
            writer.key("fields");
            writer.startArray();
            for (int i = 0; i < size; ++i) {
                EmailInfo recipient = recipients.get(i);
                if (recipient.hasUid()) {
                    empty = false;
                    writer.startObject();
                    writer.key("uid");
                    writer.value(recipient.getUid().getValue());
                    writer.endObject();
                } else if (context.logger().isLoggable(Level.INFO)) {
                    context.logger().info("No uid for " + recipient);
                }
            }
            writer.endArray();
            writer.endObject();
            writer.endArray();
        } catch (IOException e) {
            callback.failed(e);
            return;
        }
        if (empty) {
            callback.completed(EMPTY_RESULT);
            return;
        }
        AsyncClient client = this.client.adjust(context.httpContext());
        client.execute(
            host,
            new BasicAsyncRequestProducerGenerator("/api/v1", sbw.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.requestsListener().createContextGeneratorFor(client),
            new JsonObjectSoFactorCallback(callback));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        ActivityExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

