package ru.yandex.mail.so.factors.types;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum BinarySoFactorType implements SoFactorType<ByteArrayProcessable> {
    BINARY;

    public static final CustomSoFactorType<ByteArrayProcessable> RAW_MAIL =
        BINARY.createCustomSoFactorType("RAW_MAIL");

    @Override
    public ByteArrayProcessable cast(final Object value) {
        if (value instanceof ByteArrayProcessable) {
            return (ByteArrayProcessable) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        if (fieldName.equals("__size__")) {
            return new SizeAccessor(this);
        } else {
            return null;
        }
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof ByteArrayProcessable) {
                return (long) ((ByteArrayProcessable) value).length();
            } else {
                return null;
            }
        }
    }
}

