package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum BooleanSoFactorType implements SoFactorType<Boolean> {
    BOOLEAN;

    public static final SoFactor<Boolean> TRUE =
        new SoFactor<>(BooleanSoFactorType.BOOLEAN, true);

    public static final SoFactor<Boolean> FALSE =
        new SoFactor<>(BooleanSoFactorType.BOOLEAN, false);

    @Override
    public Boolean cast(final Object value) {
        if (value instanceof Boolean) {
            return (Boolean) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        return fieldAccessorFor(this, fieldName);
    }

    public static SoFactorFieldAccessorBase fieldAccessorFor(
        final SoFactorType<?> variableType,
        final String fieldName)
    {
        switch (fieldName) {
            case "__string__":
                return new StringAccessor(variableType);
            case "__json_object__":
                return new JsonObjectAccessor(variableType);
            default:
                return null;
        }
    }

    public static class StringAccessor extends SoFactorFieldAccessorBase {
        public StringAccessor(final SoFactorType<?> variableType) {
            super(variableType, StringSoFactorType.STRING, ".__string__");
        }

        @Override
        public String extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Boolean) {
                return ((Boolean) value).toString();
            }
            return null;
        }
    }

    public static class JsonObjectAccessor extends SoFactorFieldAccessorBase {
        public JsonObjectAccessor(final SoFactorType<?> variableType) {
            super(
                variableType,
                JsonObjectSoFactorType.JSON_OBJECT,
                ".__json_object__");
        }

        @Override
        public JsonBoolean extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Boolean) {
                return JsonBoolean.valueOf(((Boolean) value).booleanValue());
            }
            return null;
        }
    }
}

