package ru.yandex.mail.so.factors.types;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.mail.so.factors.OverrideTypeSoFactorFieldAccessor;
import ru.yandex.mail.so.factors.SoFactorFieldAccessor;

public class CustomSoFactorType<T>
    extends AbstractStringBuilderable
    implements SoFactorType<T>
{
    private final String name;
    private final SoFactorType<T> realType;

    public CustomSoFactorType(
        final String name,
        final SoFactorType<T> realType)
    {
        this.name = name;
        this.realType = realType.realType();
    }

    @Override
    public SoFactorFieldAccessor fieldAccessorFor(final String fieldName) {
        return new OverrideTypeSoFactorFieldAccessor(
            realType.fieldAccessorFor(fieldName),
            this);
    }

    @Override
    public SoFactorFieldAccessor fieldAccessorFor(final int fieldIndex) {
        return new OverrideTypeSoFactorFieldAccessor(
            realType.fieldAccessorFor(fieldIndex),
            this);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public T cast(final Object value) {
        return realType.cast(value);
    }

    @Override
    public SoFactorType<T> realType() {
        return realType;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        realType.toStringBuilder(sb);
        sb.append('(');
        sb.append(name);
        sb.append(')');
    }

    @Override
    public int hashCode() {
        return realType.hashCode() ^ name.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof CustomSoFactorType) {
            CustomSoFactorType<?> other = (CustomSoFactorType<?>) o;
            return realType == other.realType && name.equals(other.name);
        }
        return false;
    }
}

