package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonString;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum DkimDomainsSoFactorType implements SoFactorType<DkimDomains> {
    DKIM_DOMAINS;

    @Override
    public DkimDomains cast(final Object value) {
        if (value instanceof DkimDomains) {
            return (DkimDomains) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        switch (fieldName) {
            case "__size__":
                return new SizeAccessor(this);
            case "__json_list__":
                return new JsonAccessor(
                    this,
                    JsonListSoFactorType.JSON_LIST,
                    ".__json_list__");
            case "__json_object__":
                return new JsonAccessor(
                    this,
                    JsonObjectSoFactorType.JSON_OBJECT,
                    "._json_object__");
            default:
                return null;
        }
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof DkimDomains) {
                return (long) ((DkimDomains) value).size();
            } else {
                return null;
            }
        }
    }

    public static class JsonAccessor extends SoFactorFieldAccessorBase {
        public JsonAccessor(
            final SoFactorType<?> variableType,
            final SoFactorType<?> fieldType,
            final String stringValue)
        {
            super(variableType, fieldType, stringValue);
        }

        @Override
        public JsonList extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof DkimDomains) {
                DkimDomains domains = (DkimDomains) value;
                JsonList list =
                    new JsonList(
                        BasicContainerFactory.INSTANCE,
                        domains.size());
                for (String domain: domains) {
                    list.add(new JsonString(domain));
                }
                return list;
            }
            return null;
        }
    }
}

