package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.JsonDouble;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum DoubleSoFactorType implements SoFactorType<Double> {
    DOUBLE;

    @Override
    public Double cast(final Object value) {
        if (value instanceof Double) {
            return (Double) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        return fieldAccessorFor(this, fieldName);
    }

    public static SoFactorFieldAccessorBase fieldAccessorFor(
        final SoFactorType<?> variableType,
        final String fieldName)
    {
        switch (fieldName) {
            case "__string__":
                return new StringAccessor(variableType);
            case "__json_object__":
                return new JsonObjectAccessor(variableType);
            default:
                return null;
        }
    }

    public static class StringAccessor extends SoFactorFieldAccessorBase {
        public StringAccessor(final SoFactorType<?> variableType) {
            super(variableType, StringSoFactorType.STRING, ".__string__");
        }

        @Override
        public String extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Double) {
                return ((Double) value).toString();
            }
            return null;
        }
    }

    public static class JsonObjectAccessor extends SoFactorFieldAccessorBase {
        public JsonObjectAccessor(final SoFactorType<?> variableType) {
            super(
                variableType,
                JsonObjectSoFactorType.JSON_OBJECT,
                ".__json_object__");
        }

        @Override
        public JsonDouble extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Double) {
                return new JsonDouble(((Double) value).doubleValue());
            }
            return null;
        }
    }
}

