package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum JsonMapSoFactorType implements SoFactorType<JsonMap> {
    JSON_MAP;

    @Override
    public JsonMap cast(final Object value) {
        if (value instanceof JsonMap) {
            return (JsonMap) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        if (fieldName.equals("__size__")) {
            return new SizeAccessor(this);
        } else {
            return JsonObjectSoFactorType.fieldAccessorFor(this, fieldName);
        }
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof JsonMap) {
                return (long) ((JsonMap) value).size();
            } else {
                return null;
            }
        }
    }
}

