package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.JsonLong;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum LongSoFactorType implements SoFactorType<Long> {
    LONG;

    @Override
    public Long cast(final Object value) {
        if (value instanceof Long) {
            return (Long) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        return fieldAccessorFor(this, fieldName);
    }

    public static SoFactorFieldAccessorBase fieldAccessorFor(
        final SoFactorType<?> variableType,
        final String fieldName)
    {
        switch (fieldName) {
            case "__double__":
                return new DoubleAccessor(variableType);
            case "__string__":
                return new StringAccessor(variableType);
            case "__json_object__":
                return new JsonObjectAccessor(variableType);
            default:
                return null;
        }
    }

    public static class DoubleAccessor extends SoFactorFieldAccessorBase {
        public DoubleAccessor(final SoFactorType<?> variableType) {
            super(variableType, DoubleSoFactorType.DOUBLE, ".__double__");
        }

        @Override
        public Double extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Long) {
                return ((Long) value).doubleValue();
            }
            return null;
        }
    }

    public static class StringAccessor extends SoFactorFieldAccessorBase {
        public StringAccessor(final SoFactorType<?> variableType) {
            super(variableType, StringSoFactorType.STRING, ".__string__");
        }

        @Override
        public String extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Long) {
                return ((Long) value).toString();
            }
            return null;
        }
    }

    public static class JsonObjectAccessor extends SoFactorFieldAccessorBase {
        public JsonObjectAccessor(final SoFactorType<?> variableType) {
            super(
                variableType,
                JsonObjectSoFactorType.JSON_OBJECT,
                ".__json_object__");
        }

        @Override
        public JsonLong extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof Long) {
                return new JsonLong(((Long) value).longValue());
            }
            return null;
        }
    }
}

