package ru.yandex.mail.so.factors.types;

import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;
import ru.yandex.parser.mail.received.ReceivedChainParser;

public enum ReceivedChainSoFactorType
    implements SoFactorType<ReceivedChainParser>
{
    RECEIVED_CHAIN;

    @Override
    public ReceivedChainParser cast(final Object value) {
        if (value instanceof ReceivedChainParser) {
            return (ReceivedChainParser) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        switch (fieldName) {
            case "source_domain":
                return new SourceDomainAccessor(this);
            default:
                return null;
        }
    }

    public static class SourceDomainAccessor
        extends SoFactorFieldAccessorBase
    {
        public SourceDomainAccessor(final SoFactorType<?> variableType) {
            super(variableType, StringSoFactorType.STRING, ".source_domain");
        }

        @Override
        public String extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof ReceivedChainParser) {
                return ((ReceivedChainParser) value).sourceDomain();
            }
            return null;
        }
    }
}

