package ru.yandex.mail.so.factors.types;

import javax.annotation.Nullable;

import ru.yandex.function.StringBuilderable;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFactorFieldAccessor;

public interface SoFactorType<T> extends StringBuilderable {
    // Downcasts passed value or returns null on type mismatch
    T cast(Object value);

    @Nullable
    default SoFactorFieldAccessor fieldAccessorFor(String fieldName) {
        return null;
    }

    @Nullable
    default SoFactorFieldAccessor fieldAccessorFor(int fieldIndex) {
        return null;
    }

    default String name() {
        return toString();
    }

    default SoFactorType<T> realType() {
        return this;
    }

    default SoFactor<T> createFactor(final T value) {
        return new SoFactor<>(this, value);
    }

    default SoFactor<T> tryCreateFactor(final Object value) {
        T castResult = cast(value);
        if (castResult == null) {
            return null;
        } else {
            return createFactor(castResult);
        }
    }

    // Name expected to be normalized using SoFactorTypesRegistry.normalizeName
    default CustomSoFactorType<T> createCustomSoFactorType(final String name) {
        return new CustomSoFactorType<>(name, this);
    }

    @Override
    default void toStringBuilder(final StringBuilder sb) {
        sb.append(this);
    }
}

