package ru.yandex.mail.so.factors.types;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class SoFactorTypesRegistry {
    private final Map<String, SoFactorType<?>> registry;

    public SoFactorTypesRegistry() throws ConfigException {
        registry = new HashMap<>();
        registerSoFactorType(BinarySoFactorType.BINARY);
    }

    public SoFactorTypesRegistry(final SoFactorTypesRegistry typesRegistry) {
        registry = new HashMap<>(typesRegistry.registry);
    }

    public <T> void registerSoFactorTypes(
        final List<CustomSoFactorType<T>> types)
        throws ConfigException
    {
        for (CustomSoFactorType<T> type: types) {
            registerSoFactorType(type);
        }
    }

    public <T> SoFactorType<T> registerSoFactorType(final SoFactorType<T> type)
        throws ConfigException
    {
        return registerSoFactorType(
            type.name().toLowerCase(Locale.ROOT),
            type);
    }

    @SuppressWarnings("unchecked")
    private <T> SoFactorType<T> registerSoFactorType(
        final String name,
        final SoFactorType<T> type)
        throws ConfigException
    {
        SoFactorType<?> oldType = registry.putIfAbsent(name, type);
        if (oldType != null && !oldType.equals(type)) {
            throw new ConfigException(
                "Can't add so factor type " + type + " for name " + name
                + " as there is already type " + oldType
                + " present for this name");
        }
        if (oldType == null) {
            return type;
        } else {
            return (SoFactorType<T>) oldType;
        }
    }

    public void registerSoFactorTypes(final SoFactorTypesRegistry other)
        throws ConfigException
    {
        for (Map.Entry<String, SoFactorType<?>> entry
            : other.registry.entrySet())
        {
            registerSoFactorType(entry.getKey(), entry.getValue());
        }
    }

    public SoFactorType<?> getFactorType(final String name) {
        return registry.get(name);
    }
}

