package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonString;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum StringListSoFactorType implements SoFactorType<StringList> {
    STRING_LIST;

    public static final CustomSoFactorType<StringList> FIELDS_LIST =
        STRING_LIST.createCustomSoFactorType("fields-list");

    @Override
    public StringList cast(final Object value) {
        if (value instanceof StringList) {
            return (StringList) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        switch (fieldName) {
            case "__size__":
                return new SizeAccessor(this);
            case "__json_list__":
                return new JsonAccessor(
                    this,
                    JsonListSoFactorType.JSON_LIST,
                    ".__json_list__");
            case "__json_object__":
                return new JsonAccessor(
                    this,
                    JsonObjectSoFactorType.JSON_OBJECT,
                    ".__json_object__");
            default:
                return null;
        }
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof StringList) {
                return (long) ((StringList) value).size();
            } else {
                return null;
            }
        }
    }

    public static class JsonAccessor extends SoFactorFieldAccessorBase {
        public JsonAccessor(
            final SoFactorType<?> variableType,
            final SoFactorType<?> fieldType,
            final String stringValue)
        {
            super(variableType, fieldType, stringValue);
        }

        @Override
        public JsonList extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof StringList) {
                StringList input = (StringList) value;
                int size = input.size();
                JsonList list =
                    new JsonList(BasicContainerFactory.INSTANCE, size);
                for (int i = 0; i < size; ++i) {
                    String str = input.get(i);
                    if (str == null) {
                        list.add(JsonNull.INSTANCE);
                    } else {
                        list.add(new JsonString(str));
                    }
                }
                return list;
            }
            return null;
        }
    }
}

