package ru.yandex.mail.so.factors.types;

import ru.yandex.json.dom.JsonList;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.SoFactorFieldAccessorBase;

public enum TikaiteDocsSoFactorType implements SoFactorType<JsonList> {
    TIKAITE_DOCS;

    @Override
    public JsonList cast(final Object value) {
        if (value instanceof JsonList) {
            return (JsonList) value;
        } else {
            return null;
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final String fieldName) {
        if (fieldName.equals("__size__")) {
            return new SizeAccessor(this);
        } else {
            return JsonObjectSoFactorType.fieldAccessorFor(this, fieldName);
        }
    }

    @Override
    public SoFactorFieldAccessorBase fieldAccessorFor(final int fieldIndex) {
        return new JsonObjectSoFactorType.IndexAccessor(this, fieldIndex);
    }

    public static class SizeAccessor extends SoFactorFieldAccessorBase {
        public SizeAccessor(final SoFactorType<?> variableType) {
            super(variableType, LongSoFactorType.LONG, ".__size__");
        }

        @Override
        public Long extractField(
            final Object value,
            final FactorsAccessViolationHandler accessViolationHandler)
        {
            if (value instanceof JsonList) {
                return (long) ((JsonList) value).size();
            } else {
                return null;
            }
        }
    }
}

