package ru.yandex.mail.so.factors.ugc;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUgcExtractorConfigBuilder
    <T extends AbstractUgcExtractorConfigBuilder<T>>
    implements ConfigBuilder<T>, UgcExtractorConfig
{
    private Map<String, UgcMatcherChainConfigBuilder> chains;

    protected AbstractUgcExtractorConfigBuilder(
        final UgcExtractorConfig config)
    {
        chains(config.chains());
    }

    protected AbstractUgcExtractorConfigBuilder(
        final IniConfig config,
        final UgcExtractorConfig defaults)
        throws ConfigException
    {
        IniConfig chainSection = config.section("chain");
        Set<String> chains = chainSection.sections().keySet();
        this.chains = new LinkedHashMap<>(chains.size() << 1);
        for (String chain: chains) {
            this.chains.put(
                chain,
                UgcExtractorConfig.matcherChainParser(chain)
                    .extract(
                        chainSection,
                        UgcMatcherChainConfigDefaults.INSTANCE));
        }
    }

    @Override
    public Map<String, UgcMatcherChainConfigBuilder> chains() {
        return chains;
    }

    public T chains(
        final Map<String, ? extends UgcMatcherChainConfig> chains)
    {
        this.chains = new LinkedHashMap<>(chains.size() << 1);
        for (Map.Entry<String, ? extends UgcMatcherChainConfig> entry
            : chains.entrySet())
        {
            this.chains.put(
                entry.getKey(),
                new UgcMatcherChainConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

