package ru.yandex.mail.so.factors.ugc;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUgcMatcherChainConfigBuilder
    <T extends AbstractUgcMatcherChainConfigBuilder<T>>
    implements ConfigBuilder<T>, UgcMatcherChainConfig
{
    private boolean discardSuffix;
    private Map<String, UgcMatcherConfigBuilder> matchers;

    protected AbstractUgcMatcherChainConfigBuilder(
        final UgcMatcherChainConfig config)
    {
        discardSuffix(config.discardSuffix());
        matchers(config.matchers());
    }

    protected AbstractUgcMatcherChainConfigBuilder(
        final IniConfig config,
        final UgcMatcherChainConfig defaults)
        throws ConfigException
    {
        discardSuffix =
            DISCARD_SUFFIX.extract(config, defaults.discardSuffix());
        IniConfig matcherSection = config.section("matcher");
        Set<String> matchers = matcherSection.sections().keySet();
        this.matchers = new LinkedHashMap<>(matchers.size() << 1);
        for (String matcher: matchers) {
            this.matchers.put(
                matcher,
                UgcMatcherChainConfig.matcherParser(matcher)
                    .extract(
                        matcherSection,
                        UgcMatcherConfigDefaults.INSTANCE));
        }
    }

    @Override
    public boolean discardSuffix() {
        return discardSuffix;
    }

    public T discardSuffix(final boolean discardSuffix) {
        this.discardSuffix = discardSuffix;
        return self();
    }

    @Override
    public Map<String, UgcMatcherConfigBuilder> matchers() {
        return matchers;
    }

    public T matchers(final Map<String, ? extends UgcMatcherConfig> matchers) {
        this.matchers = new LinkedHashMap<>(matchers.size() << 1);
        for (Map.Entry<String, ? extends UgcMatcherConfig> entry
            : matchers.entrySet())
        {
            this.matchers.put(
                entry.getKey(),
                new UgcMatcherConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

