package ru.yandex.mail.so.factors.ugc;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUgcMatcherConfigBuilder
    <T extends AbstractUgcMatcherConfigBuilder<T>>
    implements ConfigBuilder<T>, UgcMatcherConfig
{
    private UgcMatcherType type;
    private String pattern;
    private boolean loadFromFile;

    protected AbstractUgcMatcherConfigBuilder(final UgcMatcherConfig config) {
        type(config.type());
        pattern(config.pattern());
        loadFromFile(config.loadFromFile());
    }

    protected AbstractUgcMatcherConfigBuilder(
        final IniConfig config,
        final UgcMatcherConfig defaults)
        throws ConfigException
    {
        type = TYPE.extract(config, defaults.type());
        pattern = PATTERN.extract(config, defaults.pattern());
        loadFromFile = LOAD_FROM_FILE.extract(config, defaults.loadFromFile());
    }

    @Override
    public UgcMatcherType type() {
        return type;
    }

    public T type(final UgcMatcherType type) {
        this.type = type;
        return self();
    }

    @Override
    public String pattern() {
        return pattern;
    }

    public T pattern(final String pattern) {
        this.pattern = pattern;
        return self();
    }

    @Override
    public boolean loadFromFile() {
        return loadFromFile;
    }

    public T loadFromFile(final boolean loadFromFile) {
        this.loadFromFile = loadFromFile;
        return self();
    }
}

