package ru.yandex.mail.so.factors.ugc;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableUgcExtractorConfig
    implements ImmutableConfig, UgcExtractorConfig
{
    private final Map<String, ImmutableUgcMatcherChainConfig> chains;

    public ImmutableUgcExtractorConfig(final UgcExtractorConfig config)
        throws ConfigException
    {
        Map<String, ? extends UgcMatcherChainConfig> chains = config.chains();
        this.chains = new LinkedHashMap<>(chains.size() << 1);
        for (Map.Entry<String, ? extends UgcMatcherChainConfig> entry
            : chains.entrySet())
        {
            String name = entry.getKey();
            this.chains.put(
                name,
                UgcExtractorConfig.matcherChainParser(name)
                    .validate(entry.getValue()));
        }
    }

    @Override
    public Map<String, ImmutableUgcMatcherChainConfig> chains() {
        return chains;
    }
}

