package ru.yandex.mail.so.factors.ugc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableUgcMatcherChainConfig
    implements ImmutableConfig, UgcMatcherChainConfig
{
    private final boolean discardSuffix;
    private final Map<String, ImmutableUgcMatcherConfig> matchers;
    private final UgcMatcherChain chain;

    public ImmutableUgcMatcherChainConfig(final UgcMatcherChainConfig config)
        throws ConfigException
    {
        discardSuffix = DISCARD_SUFFIX.validate(config.discardSuffix());
        Map<String, ? extends UgcMatcherConfig> matchers =
            config.matchers();
        this.matchers = new LinkedHashMap<>(matchers.size() << 1);
        List<UgcMatcher> matchersList = new ArrayList<>(matchers.size());
        for (Map.Entry<String, ? extends UgcMatcherConfig> entry
            : matchers.entrySet())
        {
            String name = entry.getKey();
            ImmutableUgcMatcherConfig matcherConfig =
                UgcMatcherChainConfig.matcherParser(name)
                    .validate(entry.getValue());
            this.matchers.put(name, matcherConfig);
            matchersList.add(matcherConfig.matcher());
        }
        chain = new UgcMatcherChain(discardSuffix, matchersList);
    }

    @Override
    public boolean discardSuffix() {
        return discardSuffix;
    }

    @Override
    public Map<String, ImmutableUgcMatcherConfig> matchers() {
        return matchers;
    }

    public UgcMatcherChain chain() {
        return chain;
    }
}

