package ru.yandex.mail.so.factors.ugc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableUgcMatcherConfig
    implements ImmutableConfig, UgcMatcherConfig
{
    private final UgcMatcherType type;
    private final String pattern;
    private final boolean loadFromFile;
    private final UgcMatcher matcher;

    public ImmutableUgcMatcherConfig(final UgcMatcherConfig config)
        throws ConfigException
    {
        type = TYPE.validate(config.type());
        pattern = PATTERN.validate(config.pattern());
        loadFromFile = LOAD_FROM_FILE.validate(config.loadFromFile());
        String pattern;
        if (loadFromFile) {
            try {
                pattern = Files.readString(Paths.get(this.pattern));
            } catch (IOException e) {
                throw new ConfigException(
                    "Failed to load pattern from file <" + this.pattern + '>',
                    e);
            }
        } else {
            pattern = this.pattern;
        }
        matcher = type.apply(pattern);
    }

    @Override
    public UgcMatcherType type() {
        return type;
    }

    @Override
    public String pattern() {
        return pattern;
    }

    @Override
    public boolean loadFromFile() {
        return loadFromFile;
    }

    public UgcMatcher matcher() {
        return matcher;
    }
}

