package ru.yandex.mail.so.factors.ugc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PatternUgcMatcher implements UgcMatcher {
    private final Pattern pattern;

    public PatternUgcMatcher(final Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    @Nullable
    public UgcMatchResult findMatch(
        @Nonnull final String str,
        final int fromIndex)
    {
        Matcher matcher = pattern.matcher(str.substring(fromIndex));
        if (matcher.find()) {
            return new UgcMatchResult(
                matcher.start() + fromIndex,
                matcher.end() + fromIndex);
        } else {
            return null;
        }
    }
}

