package ru.yandex.mail.so.factors.ugc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StartsWithUgcMatcher implements UgcMatcher {
    private final String needle;
    private final int needleLen;

    public StartsWithUgcMatcher(final String needle) {
        this.needle = needle;
        needleLen = needle.length();
    }

    @Override
    @Nullable
    public UgcMatchResult findMatch(
        @Nonnull final String str,
        final int fromIndex)
    {
        if (str.substring(fromIndex).startsWith(needle)) {
            return new UgcMatchResult(0, needleLen);
        } else {
            return null;
        }
    }
}

