package ru.yandex.mail.so.factors.ugc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringUgcMatcher implements UgcMatcher {
    private final String needle;
    private final int needleLen;

    public StringUgcMatcher(final String needle) {
        this.needle = needle;
        needleLen = needle.length();
    }

    @Override
    @Nullable
    public UgcMatchResult findMatch(
        @Nonnull final String str,
        final int fromIndex)
    {
        int idx = str.indexOf(needle, fromIndex);
        if (idx == -1) {
            return null;
        } else {
            return new UgcMatchResult(idx, idx + needleLen);
        }
    }
}

