package ru.yandex.mail.so.factors.ugc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringList;
import ru.yandex.mail.so.factors.types.StringListSoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UgcExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);
    private static final List<SoFactorType<?>> OUTPUTS =
        Arrays.asList(
            StringSoFactorType.STRING,
            StringListSoFactorType.STRING_LIST);
    private static final List<SoFactor<?>> NULL_RESULT =
        Arrays.asList(null, null);

    private final ImmutableUgcExtractorConfig config;

    public UgcExtractor(final IniConfig config) throws ConfigException {
        this.config =
            new UgcExtractorConfigBuilder(
                new UgcExtractorConfigBuilder(config).build())
                .build();
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String input = inputs.get(0, StringSoFactorType.STRING);
        if (input == null || input.isEmpty()) {
            callback.completed(NULL_RESULT);
            return;
        }
        for (Map.Entry<String, ImmutableUgcMatcherChainConfig> entry
            : config.chains().entrySet())
        {
            StringList ugc = entry.getValue().chain().extractUgc(input);
            if (ugc != null) {
                List<SoFactor<?>> factors = new ArrayList<>(2);
                factors.add(
                    StringSoFactorType.STRING.createFactor(entry.getKey()));
                factors.add(
                    StringListSoFactorType.STRING_LIST.createFactor(ugc));
                callback.completed(factors);
                return;
            }
        }
        callback.completed(NULL_RESULT);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        UgcExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

