package ru.yandex.mail.so.factors.ugc;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UgcExtractorConfigBuilder
    extends AbstractUgcExtractorConfigBuilder<UgcExtractorConfigBuilder>
{
    public UgcExtractorConfigBuilder() {
        super(UgcExtractorConfigDefaults.INSTANCE);
    }

    public UgcExtractorConfigBuilder(final UgcExtractorConfig config) {
        super(config);
    }

    public UgcExtractorConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, UgcExtractorConfigDefaults.INSTANCE);
    }

    public UgcExtractorConfigBuilder(
        final IniConfig config,
        final UgcExtractorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UgcExtractorConfigBuilder self() {
        return this;
    }

    public ImmutableUgcExtractorConfig build() throws ConfigException {
        return new ImmutableUgcExtractorConfig(this);
    }
}

