package ru.yandex.mail.so.factors.ugc;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.mail.so.factors.types.StringList;

public class UgcMatcherChain {
    private final boolean discardSuffix;
    private final UgcMatcher[] matchers;

    public UgcMatcherChain(
        final boolean discardSuffix,
        final List<UgcMatcher> matchers)
    {
        this.discardSuffix = discardSuffix;
        this.matchers = matchers.toArray(new UgcMatcher[matchers.size()]);
    }

    @Nullable
    public StringList extractUgc(@Nonnull final String str) {
        UgcMatchResult firstMatch = matchers[0].findMatch(str, 0);
        if (firstMatch == null) {
            return null;
        }
        UgcMatchResult[] matches = new UgcMatchResult[matchers.length];
        matches[0] = firstMatch;
        for (int i = 1; i < matchers.length; ++i) {
            UgcMatchResult match =
                matchers[i].findMatch(str, matches[i - 1].end());
            if (match == null) {
                return null;
            } else {
                matches[i] = match;
            }
        }
        StringList ugc = new StringList(matchers.length + 1);
        int prev = 0;
        for (UgcMatchResult match: matches) {
            if (prev < match.start()) {
                String substring = str.substring(prev, match.start()).trim();
                if (!substring.isEmpty()) {
                    ugc.add(substring);
                }
            }
            prev = match.end();
        }
        if (!discardSuffix && prev < str.length()) {
            String substring = str.substring(prev).trim();
            if (!substring.isEmpty()) {
                ugc.add(substring);
            }
        }
        return ugc;
    }
}

