package ru.yandex.mail.so.factors.ugc;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.BooleanParser;

public interface UgcMatcherChainConfig {
    ParameterConfig<Boolean> DISCARD_SUFFIX = new ParameterConfig<>(
        "discard-suffix",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    static SectionConfig<
        UgcMatcherConfig,
        ImmutableUgcMatcherConfig,
        UgcMatcherConfigBuilder>
    matcherParser(final String name) {
        return new SectionConfig<>(
            name,
            UgcMatcherConfigBuilder::new,
            ImmutableUgcMatcherConfig::new);
    }

    boolean discardSuffix();

    Map<String, ? extends UgcMatcherConfig> matchers();
}

