package ru.yandex.mail.so.factors.ugc;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UgcMatcherChainConfigBuilder
    extends AbstractUgcMatcherChainConfigBuilder<UgcMatcherChainConfigBuilder>
{
    public UgcMatcherChainConfigBuilder() {
        super(UgcMatcherChainConfigDefaults.INSTANCE);
    }

    public UgcMatcherChainConfigBuilder(final UgcMatcherChainConfig config) {
        super(config);
    }

    public UgcMatcherChainConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, UgcMatcherChainConfigDefaults.INSTANCE);
    }

    public UgcMatcherChainConfigBuilder(
        final IniConfig config,
        final UgcMatcherChainConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UgcMatcherChainConfigBuilder self() {
        return this;
    }

    public ImmutableUgcMatcherChainConfig build() throws ConfigException {
        return new ImmutableUgcMatcherChainConfig(this);
    }
}

