package ru.yandex.mail.so.factors.ugc;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface UgcMatcherConfig {
    ParameterConfig<UgcMatcherType> TYPE = new ParameterConfig<>(
        "type",
        new EnumParser<>(UgcMatcherType.class),
        GenericFunction.identity());
    ParameterConfig<String> PATTERN = new ParameterConfig<>(
        "pattern",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Boolean> LOAD_FROM_FILE = new ParameterConfig<>(
        "load-from-file",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    UgcMatcherType type();

    String pattern();

    boolean loadFromFile();
}

