package ru.yandex.mail.so.factors.ugc;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UgcMatcherConfigBuilder
    extends AbstractUgcMatcherConfigBuilder<UgcMatcherConfigBuilder>
{
    public UgcMatcherConfigBuilder() {
        super(UgcMatcherConfigDefaults.INSTANCE);
    }

    public UgcMatcherConfigBuilder(final UgcMatcherConfig config) {
        super(config);
    }

    public UgcMatcherConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, UgcMatcherConfigDefaults.INSTANCE);
    }

    public UgcMatcherConfigBuilder(
        final IniConfig config,
        final UgcMatcherConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UgcMatcherConfigBuilder self() {
        return this;
    }

    public ImmutableUgcMatcherConfig build() throws ConfigException {
        return new ImmutableUgcMatcherConfig(this);
    }
}

