package ru.yandex.mail.so.factors.ugc;

import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ConfigException;

public enum UgcMatcherType
    implements GenericFunction<String, UgcMatcher, ConfigException>
{
    STRING {
        @Override
        public UgcMatcher apply(final String str) {
            return new StringUgcMatcher(str);
        }
    },
    STARTS_WITH {
        @Override
        public UgcMatcher apply(final String str) {
            return new StartsWithUgcMatcher(str);
        }
    },
    ENDS_WITH {
        @Override
        public UgcMatcher apply(final String str) {
            return new EndsWithUgcMatcher(str);
        }
    },
    REGEX {
        @Override
        public UgcMatcher apply(final String str) throws ConfigException {
            Pattern pattern;
            try {
                pattern = Pattern.compile(str, Pattern.DOTALL);
            } catch (RuntimeException e) {
                throw new ConfigException(
                    "Failed to parse pattern <" + str + '>',
                    e);
            }
            return new PatternUgcMatcher(pattern);
        }
    };
}

