package ru.yandex.mail.so.factors.dsl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.parser.config.ConfigException;

public class DslParser extends DslParserBase {
    %% machine DslParser;
    %% write data;

    private static final int INITIAL_STACK_LENGTH = 16;

    private int[] stack = new int[INITIAL_STACK_LENGTH];
    private int cs;
    private int top;

    public DslParser(SoFactorsExtractorFactoryContext context) {
        super(context);
        %% write init;
    }

    @Override
    @SuppressWarnings("fallthrough")
    protected void processLine(final String line)
        throws ConfigException, IOException
    {
        char[] data;
        int p;
        int pe;
        int eof;
        if (line == null) {
            data = null;
            p = 0;
            pe = 0;
            eof = 0;
        } else {
            data = line.toCharArray();
            p = 0;
            pe = data.length;
            eof = -1;
        }
        %%{
            action clear_buffer_add_char {
                buffer.setLength(0);
                buffer.append(data[p - 1]);
            }

            action clear_buffer {
                buffer.setLength(0);
            }

            action add_char {
                buffer.append(fc);
            }

            action add_open_curly_bracket {
                buffer.append('{');
            }

            action add_close_curly_bracket {
                buffer.append('}');
            }

            action add_backslash {
                buffer.append('\\');
            }

            action add_double_quote {
                buffer.append('\"');
            }

            action add_cr {
                buffer.append('\r');
            }

            action add_lf {
                buffer.append('\n');
            }

            action add_tab {
                buffer.append('\t');
            }

            action clear_arguments_definition {
                arguments.clear();
            }

            action argument_type {
                argumentType =
                    parseType(buffer.toString(), "input", arguments.size());
            }

            action argument_name {
                arguments.add(
                    new SoFunctionArgumentInfo(
                        argumentType,
                        buffer.toString()));
            }

            action arguments_definition_end {
            }

            action predicate_type_end {
                commitPredicateType();
            }

            action predicate_name_end {
                predicateName = buffer.toString();
            }

            action predicate_end {
                commitPredicate();
            }

            action clear_variables_list {
                variables.clear();
            }

            action add_variable {
                variables.add(buffer.toString());
            }

            action clear_call_arguments {
                callArguments.clear();
            }

            action add_token_argument {
                String image = buffer.toString();
                switch (image) {
                    case "null":
                        callArguments.add(
                            new SoCallArgument(
                                image,
                                SoCallArgument.Type.NULL));
                        break;
                    case "true":
                    case "false":
                        callArguments.add(
                            new SoCallArgument(
                                image,
                                SoCallArgument.Type.BOOLEAN));
                        break;
                    default:
                        callArguments.add(
                            new SoCallArgument(
                                image,
                                SoCallArgument.Type.TOKEN));
                        break;
                }
            }

            action add_number_argument {
                callArguments.add(
                    new SoCallArgument(
                        buffer.toString(),
                        SoCallArgument.Type.NUMBER));
            }

            action add_string_argument {
                callArguments.add(
                    new SoCallArgument(
                        buffer.toString(),
                        SoCallArgument.Type.STRING));
            }

            action extractor_type_end {
                commitExtractorType();
            }

            action extractor_name_end {
                extractorName = buffer.toString();
            }

            action extractor_body {
                if (top == stack.length) {
                    stack = Arrays.copyOf(stack, top << 1);
                }
                if (extractorType == null) {
                    pushChainExtractor();
                    fcall chain_extractor_body;
                } else {
                    fcall simple_extractor_body;
                }
            }

            action chain_extractor_end {
                popChainExtractor();
                fret;
            }

            action simple_extractor_end {
                commitSimpleExtractor();
                fret;
            }

            action call_name {
                callName = buffer.toString();
            }

            action pragma_critical {
                criticalDefault = true;
                critical = true;
            }

            action pragma_noncritical {
                criticalDefault = false;
                critical = false;
            }

            action set_trace {
                trace = true;
            }

            action set_async {
                async = true;
            }

            action set_critical {
                critical = true;
            }

            action set_noncritical {
                critical = false;
            }

            action set_alias {
                alias = buffer.toString();
            }

            action call_arguments {
            }

            action predicate_arguments {
                predicateArguments = new ArrayList<>(callArguments);
            }

            action call_end {
                commitCall();
            }

            action return_name {
                returns = new ArrayList<>(callArguments);
            }

            action set_not {
                invertPredicate = true;
            }

            action return_predicate_name {
                commitReturnPredicate();
            }

            action return_else_name {
                elses = new ArrayList<>(callArguments);
            }

            action return_end {
                commitReturn();
            }

            action imports_list {
            }

            action import_file {
                commitImport(buffer.toString());
                variables.clear();
            }

            keywords =
                "and"
                | "as"
                | "async"
                | "create"
                | "critical"
                | "else"
                | "extractor"
                | "from"
                | "if"
                | "import"
                | "noncritical"
                | "not"
                | "or"
                | "pragma"
                | "predicate"
                | "return"
                | "trace";
            cfws = space | "#" [^\n]* "\n";
            word = [a-zA-Z_][a-zA-Z0-9_]* >clear_buffer_add_char $add_char - keywords;
            token = word (("." [a-zA-Z_]([a-zA-Z0-9_]|"\\.")* | "[" ("0" | [1-9][0-9]*) "]")* $add_char);
            number = ("-"? ("0" | [1-9][0-9]*) ("." [0-9]+)? ([eE] "-"? [1-9][0-9]*)?) >clear_buffer $add_char;
            string_literal = (
                "\\\"" %add_double_quote
                |
                "\\\\" %add_backslash
                |
                "\\r" %add_cr
                |
                "\\n" %add_lf
                |
                "\\t" %add_tab
                |
                [^"\\] $add_char
                )* >clear_buffer;
            function_body = (
                "\\{" %add_open_curly_bracket
                |
                "\\}" %add_close_curly_bracket
                |
                "\\\\" %add_backslash
                |
                [^{}\\] $add_char
                )* >clear_buffer;
            argument_definition = word %argument_type cfws+ word %argument_name;
            arguments_definition =
                cfws* "(" %clear_arguments_definition
                cfws* (argument_definition (cfws* "," cfws* argument_definition)* cfws*)?
                ")" %arguments_definition_end;
            variables_list = word %add_variable (cfws* "," cfws* word %add_variable)*;
            call_argument =
                token %add_token_argument
                |
                number %add_number_argument
                |
                ["] string_literal ["] %add_string_argument;

            predicate_definition =
                "predicate" %predicate_type_end
                cfws+ word %predicate_name_end
                arguments_definition cfws* "{" function_body "}" >predicate_end;

            extractor_definition =
                "extractor" %extractor_type_end
                cfws+ word %extractor_name_end
                arguments_definition cfws*
                "->"
                %clear_variables_list
                cfws*
                variables_list
                cfws* "{" >extractor_body;

            simple_extractor_body := function_body "}" >simple_extractor_end;

            call =
                ("trace" %set_trace cfws+ | "async" %set_async cfws+ | "critical" %set_critical cfws+ | "noncritical" %set_noncritical cfws+)*
                word (cfws+ "as" %call_name cfws+ word %set_alias cfws* "("| cfws* "(" %call_name) %clear_call_arguments
                cfws* (call_argument (cfws* "," cfws* call_argument)* cfws*)?
                ")" > call_arguments
                cfws* "->" cfws* %clear_variables_list cfws* variables_list cfws* ";" %call_end;

            return_predicate =
                "if" cfws+ ("not" %set_not cfws+)? word %return_predicate_name
                (
                    cfws* "(" %clear_call_arguments cfws*
                    (call_argument (cfws* "," cfws* call_argument)* cfws*)?
                    ")"
                ) %predicate_arguments
                (cfws+ "else" cfws+ %clear_call_arguments call_argument (cfws* "," cfws* call_argument)* %return_else_name)?;

            return = "return" cfws+ %clear_call_arguments call_argument (cfws* "," cfws* call_argument)* %return_name (cfws+ return_predicate)? cfws* ";" > return_end;

            chain_extractor_body :=
                cfws* (
                (
                    "create" cfws+ word cfws+ (predicate_definition | extractor_definition)
                    |
                    call
                    |
                    return
                )
                cfws*)*
                "}" >chain_extractor_end;

            main :=
                (
                    cfws* "pragma" cfws+ ("critical" %pragma_critical | "noncritical" %pragma_noncritical) cfws* [;] cfws*
                    |
                    cfws* "import" cfws+ variables_list cfws+ "from" %imports_list cfws+ ["] %clear_buffer ([^"] $add_char)+ ["][;] cfws* %import_file cfws*
                    |
                    cfws* "create" cfws+ word cfws+ (predicate_definition | extractor_definition) cfws*
                )*;

            write exec;
        }%%
        if (p < pe) {
            reportError(data[p], p);
        }
    }
}

