package ru.yandex.mail.so.factors.http;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

import org.apache.http.protocol.HttpContext;

import ru.yandex.function.FalseSupplier;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.FilterCancellationSubscriber;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.parser.mail.errors.ErrorInfo;

public class HttpSoFactorsExtractorContext
    extends FilterCancellationSubscriber
    implements SoFactorsExtractorContext
{
    private final ProxySession session;
    private final FactorsAccessViolationHandler accessViolationHandler;
    private final Consumer<ErrorInfo> errorsConsumer;
    private final Executor executor;
    private final BooleanSupplier cancellationFlag;
    private final boolean debugExtractors;

    public HttpSoFactorsExtractorContext(
        final ProxySession session,
        final FactorsAccessViolationHandler accessViolationHandler,
        final Consumer<ErrorInfo> errorsConsumer,
        final Executor executor)
    {
        this(
            session,
            accessViolationHandler,
            errorsConsumer,
            executor,
            FalseSupplier.INSTANCE);
    }

    public HttpSoFactorsExtractorContext(
        final ProxySession session,
        final FactorsAccessViolationHandler accessViolationHandler,
        final Consumer<ErrorInfo> errorsConsumer,
        final Executor executor,
        final BooleanSupplier cancellationFlag)
    {
        super(session);
        this.session = session;
        this.accessViolationHandler = accessViolationHandler;
        this.errorsConsumer = errorsConsumer;
        this.executor = executor;
        this.cancellationFlag = cancellationFlag;
        debugExtractors = session.debugFlags().contains("extractors");
    }

    @Override
    public boolean cancelled() {
        return cancellationFlag.getAsBoolean() || super.cancelled();
    }

    @Override
    public FactorsAccessViolationHandler accessViolationHandler() {
        return accessViolationHandler;
    }

    @Override
    public PrefixedLogger logger() {
        return session.logger();
    }

    @Override
    public HttpContext httpContext() {
        return session.context();
    }

    @Override
    public RequestsListener requestsListener() {
        return session.listener();
    }

    @Override
    public Consumer<ErrorInfo> errorsConsumer() {
        return errorsConsumer;
    }

    @Override
    public Executor executor() {
        return executor;
    }

    @Override
    public boolean debugExtractors() {
        return debugExtractors;
    }

    @Override
    public Set<String> debugFlags() {
        return session.debugFlags();
    }
}

