
#include <util/string/cast.h>
#include "crop.h"


namespace NLSA {
    bool TCropProjector::Accept(const TStringBuf &funcName) noexcept {
        return funcName == NAME;
    }

    TSimpleSharedPtr<const TCropProjector> TCropProjector::Make(const TStringBuf &args) {
        const auto count = IntFromString<size_t, 10>(args);
        return MakeSimpleShared<const TCropProjector>(count);
    }

    TCropProjector::TCropProjector(size_t count) noexcept
    : Count(count)
    , Represantation(TString(NAME) + '(' + ToString(Count) + ')') {
    }

    size_t TCropProjector::GetCount() const {
        return Count;
    }

    TVector<TString> TCropProjector::Apply(const TVector<TString> &words) const {
        return TVector<TString>(words.cbegin(), std::next(words.cbegin(), std::min(Count, words.size())));
    }

    const TString &TCropProjector::GetRepresentation() const {
        return Represantation;
    }
}
