#pragma once

#include <util/generic/string.h>
#include "projector.h"

namespace NLSA {
    class TCropProjector : public IProjector {
        static const constexpr TStringBuf NAME = "crop";
    public:
        static bool Accept(const TStringBuf& funcName) noexcept;
        static TSimpleSharedPtr<const TCropProjector> Make(const TStringBuf& args);

        explicit TCropProjector(size_t count) noexcept;

        [[nodiscard]] size_t GetCount() const;

        [[nodiscard]] TVector <TString> Apply(const TVector <TString> &words) const override;

        [[nodiscard]] const TString &GetRepresentation() const override;

    private:
        size_t Count;
        TString Represantation;
    };
}
