#include <util/generic/yexception.h>
#include "factory.h"
#include "crop.h"
#include "segment.h"
#include "plainify.h"

namespace NLSA {
    TSimpleSharedPtr<const IProjector> ProjectorFactory(const TStringBuf &src) {

        if (TPlainifyProjector::Accept(src)){
            return TPlainifyProjector::Make();
        }

        const size_t braceOpen = src.find('(');
        if (braceOpen == NPOS) {
            ythrow TWithBackTrace<yexception>() << "field projector must be like functor(arg1,arg2)";
        }

        const size_t braceClose = src.find(')', braceOpen + 1);
        if (braceClose == NPOS) {
            ythrow TWithBackTrace<yexception>() << "field projector must be like functor(arg1,arg2)";
        }

        const TStringBuf functorName = src.substr(0, braceOpen);
        const TStringBuf args = src.substr(braceOpen + 1, braceClose - braceOpen - 1);

        if (TCropProjector::Accept(functorName)) {
            return TCropProjector::Make(args);
        }

        if (TSegmentProjector::Accept(functorName)) {
            return TSegmentProjector::Make(args);
        }

        ythrow TWithBackTrace<yexception>() << "cannot parse field projector from <" << src << '>';
    }
}
