#pragma once

#include "projector.h"
#include "fields.h"

namespace NLSA {
    class TProjectorField : public IProjector {
    public:
        static TProjectorField Parse(const TStringBuf& src);
        [[nodiscard]] TVector<TString> Apply(const TVector<TString>& words) const override;
        [[nodiscard]] TField GetField() const;
        [[nodiscard]] const TString& GetRepresentation() const override;

        explicit TProjectorField(TField field) noexcept : TProjectorField(field, TVector<TSimpleSharedPtr<const IProjector>>{}) {}
        TProjectorField(TField field, TVector<TSimpleSharedPtr<const IProjector>> projectors) noexcept;
    private:
        TField Field;
        TVector<TSimpleSharedPtr<const IProjector>> Projectors;
        TString Represantation;
    };
} // namespace NLSA
