#pragma once

#include <util/generic/serialized_enum.h>

namespace NLSA {
    enum class TField {
        Body /* "body" */,
        Subject /* "subject" */,
        Fromname /* "fromname" */,
        Fromaddr /* "fromaddr" */,
        PureBody /* "pure_body" */,
        PureSubject /* "pure_subject" */,
        FullBody /* "full_body" */,
        FullSubject /* "full_subject" */,

        PureDeobfuscatedBody /* "pure_deobfuscated_body" */,
        PureDeobfuscatedSubject /* "pure_deobfuscated_subject" */,

        Sherlock /* "sherlock" */,
        Attach /* "attach" */,

        FullFromAddr /* "full_fromaddr" */,
        FullFromAddrLogin /* "full_fromlogin" */,

        PureDeobfuscatedFromname /* "pure_deobfuscated_fromname" */,
        PureDeobfuscatedFromaddr /* "pure_deobfuscated_fromaddr" */,

        PureDeobfuscatedAttachesNames /* "pure_deobfuscated_attaches_names" */,
    };

    constexpr const auto NonSecureFields = {TField::Body, TField::Subject, TField::Fromname, TField::Fromaddr, TField::FullBody, TField::FullSubject};
    constexpr const auto AllFields = {
            TField::Body,
            TField::Subject,
            TField::Fromname,
            TField::Fromaddr,
            TField::PureBody,
            TField::PureSubject,
            TField::FullBody,
            TField::FullSubject,
            TField::PureDeobfuscatedBody,
            TField::PureDeobfuscatedSubject,
            TField::Sherlock,
            TField::Attach,
            TField::FullFromAddr,
            TField::FullFromAddrLogin,
            TField::PureDeobfuscatedFromname,
            TField::PureDeobfuscatedFromaddr,
            TField::PureDeobfuscatedAttachesNames,
    };
}

template <> constexpr size_t GetEnumItemsCount<NLSA::TField>() { return NLSA::AllFields.size(); } // todo make with GENERATE_ENUM_SERIALIZATION_WITH_HEADER
