#include <util/string/cast.h>
#include "plainify.h"

#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_value.h>
#include <util/string/split.h>
#include <util/string/join.h>
#include <util/generic/strbuf.h>

namespace NLSA {
    bool TPlainifyProjector::Accept(const TStringBuf& funcName) noexcept {
        return funcName == NAME;
    }

    TSimpleSharedPtr<const TPlainifyProjector> TPlainifyProjector::Make() {
        return MakeSimpleShared<const TPlainifyProjector>();
    }

    TPlainifyProjector::TPlainifyProjector() noexcept{}

    TVector<TString> TPlainifyProjector::Apply(const TVector<TString>& words) const {
        TString out;
        if (words.empty() || (words.size() == 1 && words[0].empty())) {
            out = "";
        } else {
            TStringInput inp(words[0]);
            NJson::TJsonValue attachesArr = NJson::ReadJsonTree(&inp, true);
            TStringStream output;
            JsonArrayToString(attachesArr, output);
            out = output.Str();
        }

        return {std::move(out)};
    }
    void TPlainifyProjector::JsonArrayToString(const NJson::TJsonValue& input, TStringStream& output) const {
        for (const auto& token : input.GetArraySafe()) {
            if (token.IsString()) {
                if (!output.empty())
                    output << " ";
                output << token.GetString();
            } else if (token.IsArray()) {
                JsonArrayToString(token, output);
            }
        }
    }

    const TString& TPlainifyProjector::GetRepresentation() const {
        return Represantation;
    }
}