#pragma once

#include <util/generic/string.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_value.h>
#include "projector.h"

namespace NLSA {
    class TPlainifyProjector: public IProjector {
        static const constexpr TStringBuf NAME = "plainify_json_array";

    public:
        static bool Accept(const TStringBuf& funcName) noexcept;
        static TSimpleSharedPtr<const TPlainifyProjector> Make();

        explicit TPlainifyProjector() noexcept;

        [[nodiscard]] TVector<TString> Apply(const TVector<TString>& words) const override;

        [[nodiscard]] const TString& GetRepresentation() const override;

    private:
        void JsonArrayToString(const NJson::TJsonValue& input, TStringStream& output) const;
        TString Represantation;
    };
}
